<?php 
/**
 * ҳ
 *
 * @author һ yandy@yanwee.com
 * @package 1.0
 * @version $Id$
 */


/**
 * Pages ҳ
 * @package Util
 */
class Pages {
	/**
	 * ʹøļ
	 * @var string
	 */
	public $fileName;
	/** 
	 * ÿҳ
	 * @var int
	 */
	public $lines;
	/**
	 * ǰҳ
	 * @var int
	 */
	public $currentPage;
	/**
	 *
	 *@var int
	 */
	public $lineCount;
	/**
	 * ҳ
	 * @var int
	 */
	public $pageCount;
	/**
	 * ģļ
	 * @var strint
	 */
	public $templateFile;
	/**
	 * 
	 * @param int $count
	 * @param string $templata_file
	 * @param int $lines
	 * @return void
	 */
	public function __construct($count, $lines=15, $template_file='pages.tpl') {
		$this->lineCount = intval($count);
		if (intval($_GET['lines'])>0) {
			$this->lines = intval($_GET['lines']);
		} else {
			$this->lines = $lines;
		}
		if ($this->lineCount<=0) {
			$this->pageCount = 1;
		} else {
			$this->pageCount = ceil($this->lineCount / $this->lines);
		}	
		$this->templateFile = $template_file;
		$uri = preg_replace('/&(pageno|lines)\=[^&]*/','', '&' . $_SERVER['QUERY_STRING']);
		$ext = '&';
		$uri = substr($uri . $ext,1);
		$this->fileName = $_SERVER['SCRIPT_NAME'] . '?' . $uri ;
		$currentPage = intval($_GET['pageno']);
		
		if ($currentPage<=0) {
			$this->currentPage = 1;
		} elseif ($currentPage>$this->pageCount) {
			$this->currentPage = $this->pageCount;
		} else {
			$this->currentPage = intval($_GET['pageno']);
		}
	}
	/**
	 * sqlҳ
	 * @param string $sql
	 * @return string
	 */
	public function getLimit() {
		$lineFrom = ($this->currentPage-1) * $this->lines + 1;
		$lineTo = $lineFrom + $this->lines - 1;
		return array('rowFrom'=>$lineFrom,'rowTo'=>$lineTo);
	}
	/**
	 * ɿ
	 * @return string
	 */
	public function showCtrlPanel()	{
		global $tpl;
		if ($this->templateFile=='wapPage.tpl') {
			$this->fileName = str_replace('&','&amp;',$this->fileName);
		}
		$vars = array(
			'lineCount'				=> $this->lineCount,	//
			'pageCount'				=> $this->pageCount,	//ҳ
			'lines'					=> $this->lines,	//ÿҳ
			'formName'				=> $this->formName,	//
			'lineFrom'				=> $lineFrom,	//ӵڼпʼ
			'lineTo'				=> $lineTo,		//ڼн
			'currentPage'			=> $this->currentPage,	//ǰҳ
			'is_disabled_cp'		=> (($this->pageCount<=1)?' disabled style="background-color:#EEEEEE"':''),
			'is_disabled_scroll'	=> (($this->currentPage<=1)?' disabled':''), //Ƿ
			'is_disabled_left'		=> (($this->currentPage<=1)?' disabled':''), //Ƿ
			'is_disabled_right'		=> (($this->currentPage>=$this->pageCount)?' disabled':''), //Ƿ
			'pageName'				=> $this->fileName,
			'nextPage'				=> $this->currentPage+1,
			'prePage'				=> $this->currentPage-1,
			);
		$tpl->assign($vars);
		
		$pageList = array();
		for($i=1; $i<=$this->pageCount; $i++){
			// $p 洢ҳ
			if($i == $this->currentPage){
				$pageList[$i] = ' selected="selected"'; // ǰҳʱ˵Ĭѡиҳ
			} else {
				$pageList[$i] = '';
			}
			
		}
		$tpl->assign('pageList',$pageList);
		
		// ģ
		return $tpl->fetch($this->templateFile);
	}
	/**
	 * ɿ google 
	 * @return string
	 */
	public function showCtrlPanel_g($halfPer = 5)	{
		
		$re = '<div class="multipage">';
		if($this->currentPage>=$this->pageCount){
	$re .= '<a href="'.$this->fileName.'pageno='.($this->currentPage-1) .'"> <span class="prexpage">һҳ</span></a>';			
			}else{
					$re .= '<span  class="nolink prexpage">һҳ</span>';
			}	
		if($this->currentPage-$halfPer >1){
			$re .= '';
			$re .= '<a href="'.$this->fileName.'pageno=1"><span>1</span></a>';
			if($this->currentPage-$halfPer*2 >1){
				$re .= '<a href="'.$this->fileName.'pageno='.($this->currentPage-$halfPer*2).'"><span>...</span></a>';
			}else{
				$re .= '<a href="'.$this->fileName.'pageno=1"><span>...</span></a>';
			}
		}
		for ( $i = $this->currentPage - $halfPer,$i > 1 || $i = 1 , $j = $this->currentPage + $halfPer, $j < $this->pageCount || $j = $this->pageCount;$i <= $j ;$i++ )
		{
			$re .= $i ==  $this->currentPage 
				? '<span class="current">'.$i.'</span>'."\n"
				: '<a href="'.$this->fileName.'pageno='.$i.'"><span>'.$i.'</span></a>'."\n";
		}
		if($this->currentPage+$halfPer < $this->pageCount){
			if($this->currentPage+$halfPer*2 < $this->pageCount){
				$re .= '<a href="'.$this->fileName.'pageno='.($this->currentPage+$halfPer*2).'"><span>...</span></a>';
			}else{
				$re .= '<a href="'.$this->fileName.'pageno='.$this->pageCount.'"><span>...</span></a>';
			}
			$re .= '<a href="'.$this->fileName.'pageno='.$this->pageCount.'"><span>'.$this->pageCount.'</span></a>';
		}
			if($this->currentPage>=$this->pageCount){
				$re .= '<span class="nextpage">һҳ</span>';
			}else{
				$re .= '<a href="'.$this->fileName.'pageno='.($this->currentPage+1) .'"> <span class="nextpage">һҳ</span></a>';	
			}	
		$re .= '</div>';
		return $re;
	}
	/**
	 * ɿ google 
	 * @return string
	 */
	public function showCtrlPanel_h($halfPer = 5)	{
		$re = '<span class="pageMoreTop">
			<ul>';
		if($this->currentPage-$halfPer >1){
			$re .= '<li><a href="'.$this->fileName.'pageno=1"><span>1</span></a></li>';
			if($this->currentPage-$halfPer*2 >1){
				$re .= '<li><a href="'.$this->fileName.'pageno='.($this->currentPage-$halfPer*2).'"><span>...</span></a></li>';
			}else{
				$re .= '<li><a href="'.$this->fileName.'pageno=1"><span>...</span></a></li>';
			}
		}
		for ( $i = $this->currentPage - $halfPer,$i > 1 || $i = 1 , $j = $this->currentPage + $halfPer, $j < $this->pageCount || $j = $this->pageCount;$i <= $j ;$i++ )
		{
			$re .= $i ==  $this->currentPage 
				? '<li class="linkOn"><a href="'.$this->fileName.'pageno='.$i.'"><span>'.$i.'</span></a></li>'."\n"
				: '<li><a href="'.$this->fileName.'pageno='.$i.'"><span>'.$i.'</span></a></li>'."\n";
		}
		if($this->currentPage+$halfPer < $this->pageCount){
			if($this->currentPage+$halfPer*2 < $this->pageCount){
				$re .= '<li><a href="'.$this->fileName.'pageno='.($this->currentPage+$halfPer*2).'"><span>...</span></a></li>';
			}else{
				$re .= '<li><a href="'.$this->fileName.'pageno='.$this->pageCount.'"><span>...</span></a></li>';
			}
			$re .= '<li><a href="'.$this->fileName.'pageno='.$this->pageCount.'"><span>'.$this->pageCount.'</span></a></li>';
		}
				
		$re .= '	
			</ul>
			</span>';
		return $re;
	}
}
?>